<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<meta name="author" content="Vikram Kumar" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="keywords" content="<?php echo $__env->yieldContent('meta-keywords'); ?>" />
    <meta name="description" content="<?php echo $__env->yieldContent('meta-desp'); ?>" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('page-title'); ?></title>
	
    <!-- favicon -->
    <!-- favicon -->
    <link rel="icon" href="<?php echo e(asset('/img/logos/favicon.png')); ?>" />

    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo e(asset('/img/logos/apple-icon-72x72.png')); ?>">

    <link rel="apple-touch-icon" sizes="114x114" href="<?php echo e(asset('/img/logos/apple-icon-114x114.png')); ?>">

    <!-- plugins -->
    <link rel="stylesheet" href="<?php echo e(asset('/css/plugins.css')); ?>" />

    <!-- theme core css -->
    <link href="<?php echo e(asset('/css/styles.css')); ?>" rel="stylesheet" id="colors">
    <?php $__env->startSection('internal-css'); ?>
    <?php echo $__env->yieldSection(); ?>

    <style>
        .list-style li a.activelink {
            color: #f8821e;
            font-weight: 600;
        }

    	@media (max-width: 991px){
	    	.bgcolor-white {
	    		background: #FFF;
	    	}
	    }
    </style>

</head>
<body>

	<!-- start main-wrapper section -->
    <div class="main-wrapper">
    	<!-- start header section -->
        <header class="position-absolute w-100 transparent-header sm-position-relative" id="header" style="background: rgba(0,0,0,0.3);">

            <div class="navbar-default bgcolor-white">
                <div class="container1 lg-container pl-md-5 pr-md-5 pl-3 pr-3">
                    <div class="row align-items-center">
                        <div class="col-12">
                            <div class="menu_area alt-font">
                                <nav class="navbar navbar-expand-lg navbar-light p-0">

                                    <div class="navbar-header navbar-header-custom" style="padding: 0px;">
                                        <!-- start logo -->
                                        <a href="<?php echo e(url('/')); ?>" class="navbar-brand inner-logo">
                                        	<table>
                                        		<tr>
                                        			<td>
                                        				
                                        			<img id="logo" src="<?php echo e(asset('/img/logos/rm_logo_white.png')); ?>" alt="logo" style="max-height: 50px !important;">
                                        			</td>	
                                        		</tr>
                                        	</table>
                                        </a>
                                        <!-- end logo -->
                                    </div>

                                    <div class="navbar-toggler"></div>

                                    <!-- start menu area -->
                                    <ul class="navbar-nav ml-auto" id="nav" style="display: none;">
                                        <li><a href="<?php echo e(url('/')); ?>">Home</a></li>
                                        <li><a href="<?php echo e(url('/about')); ?>">About Us</a></li>
                                        <li><a href="javascript:void(0)">Products</a>
                                            <ul>
                                                <li><a href="javascript:void(0)">Water Treatment Plant</a>
                                                    <ul style="z-index: 9999;">
                                                        <li><a href="<?php echo e(url('/products/water-treatment-plant/mineral-water-plant')); ?>">Mineral Water Plant</a></li>
                                                        <li><a href="<?php echo e(url('/products/water-treatment-plant/water-filling-machine')); ?>">Water Filling Machine</a></li>
                                                        <li><a href="<?php echo e(url('/products/water-treatment-plant/1-litre-bottling-plant')); ?>">1 Litre Bottling Plant</a></li>
                                                        <li><a href="<?php echo e(url('/products/water-treatment-plant/industrial-ro-water-plant')); ?>">Industrial RO Water Plant</a></li>
                                                        <li><a href="<?php echo e(url('/products/water-treatment-plant/water-softening-plant')); ?>">Water Softening Plant</a></li>
                                                    </ul>
                                                </li>

                                                <li><a href="javascript:void(0)" class="pr-3">Waste Water Treatment Plant</a>
                                                    <ul style="z-index: 9999;">
                                                        <li><a href="<?php echo e(url('/products/waste-water-treatment-plant/sewage-treatment-plant')); ?>">Sewage Treatment Plant</a></li>
                                                        <li><a href="<?php echo e(url('/products/waste-water-treatment-plant/effluent-treatment-plant')); ?>">Effluent Treatment Plant</a></li>
                                                    </ul>
                                                </li>
                                            </ul>
                                        </li>
                                        
                                        <li><a href="<?php echo e(url('/service-support')); ?>">Service & Support</a></li>
                                        <li><a href="<?php echo e(url('/contact')); ?>">Contact Us</a></li>
                                    </ul>
                                    <!-- end menu area -->
                                    <div class="ml-4 d-none d-lg-inline-block">
                                        <a class="butn style-four small" href="<?php echo e(url('/enquiry')); ?>">Enquiry</a>
                                    </div>

                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </header>
        <!-- end header section -->

        <?php $__env->startSection('content'); ?>
        <?php echo $__env->yieldSection(); ?>

        <!-- start footer section -->
        <footer class="footer-style3 bg-white bg-img cover-background" data-background="<?php echo e(asset('/img/bg/footer.png')); ?>">
            <div class="container lg-container">
                <div class="footer-5">
                    <div class="row">
                        <div class="col">
                            <span class="footer-logo mb-1-6 d-inline-block">
                                <table>
                                    <tr>
                                        <td>
                                            
                                        <img id="logo" src="<?php echo e(asset('/img/logos/rm_logo_white.png')); ?>" alt="logo" style="max-height: 72px !important; border-radius: 10px;">
                                        </td>
                                    </tr>
                                </table>
                            </span>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-4 col-md-6 mb-5 mb-lg-0">
                            <div style="padding: 15px; box-shadow: 0rem 0rem 0.5rem rgb(255 255 255) !important; margin-bottom: 20px; border-radius: 5px;">
                                <b><span style="color: #f8821e">Hydro X</span> <span style="color: #00aeef">Water Treatment Pvt Ltd</span></b><br>
                                <span style="color: #ffc107; font-weight: 500;">+91-983-860-0270</span>
                            </div>
                            <p>
                                B 97 NOIDA SECTOR 64, <br>
                                Gautam Buddha Nagar, <br />
                                201301 Uttar Pradesh, India <br><br>
                            </p>
                        </div>

                        <div class="col-lg-4 pl-lg-5 col-md-6 mb-5 mb-lg-0">
                        	<h3>Contact</h3>
                            <span class="font-weight-700 text-white">Mr. Rahul Tiwari (CEO)</span>
                            <ul>
                                <li><a href="mailto:conatct@hydroxwatertreatment.com">conatct@hydroxwatertreatment.com</a></li>
                                <li><a href="tel:+91-983-860-0270">+91-983-860-0270</a></li>
                                <li><a href="tel:+91-9838600270">+91-9838600270</a></li>
                            </ul>
                            <div class="footer-icon">
                                <ul class="mb-0">
                                    <li>
                                        <a href="#!"><i class="fab fa-facebook-f"></i></a>
                                    </li>
                                    <li>
                                        <a href="#!"><i class="fab fa-twitter"></i></a>
                                    </li>
                                    <li>
                                        <a href="#!"><i class="fab fa-dribbble"></i></a>
                                    </li>
                                    <li>
                                        <a href="#!"><i class="fab fa-linkedin-in"></i></a>
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 mb-5 mb-md-0">
                            <h3>Our Products</h3>
                            <ul class="mb-0">
                                <li><a href="<?php echo e(url('/products/stainless-steel-buttweld-fittings')); ?>">Water Treatment Plant</a></li>
                                <li><a href="<?php echo e(url('/products/stainless-steel-flanges')); ?>">Wastewater Treatment Plant</a></li>
                                <li><a href="#!">Water Ionizer Machine</a></li>
                                <li><a href="#!">Enagic Kangen Water Machine</a></li>

                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="footer-style3-bottom mt-3">
                <div class="container">
                    <p>&copy;
                        <script>
                            document.write(new Date().getFullYear())
                        </script> Copyright | All rights reserved</p>
                </div>
            </div>
        </footer>
        <!-- end footer section -->

    </div>
    <!-- end main-wrapper section -->
	

	<!-- start scroll to top -->
    <a href="javascript:void(0)" class="scroll-to-top"><i class="fas fa-angle-up" aria-hidden="true"></i></a>
    <!-- end scroll to top -->

    <!-- all js include start -->
    <script type="text/javascript" src="<?php echo e(asset('/img/slider/engine1/wowslider.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('/img/slider/engine1/script.js')); ?>"></script>

    <!-- jquery -->
    <script src="<?php echo e(asset('/js/core.min.js')); ?>"></script>

    <!-- bootstrap -->
    <script src="<?php echo e(asset('/js/bootstrap.min.js')); ?>"></script>

    <!-- custom scripts -->
    <script src="<?php echo e(asset('/js/main.js')); ?>"></script>
    <!-- all js include end -->
</body>
</html><?php /**PATH /Users/vikramkumar/Documents/Projects/NR/Web/HydroX/resources/views/layouts/main_layout.blade.php ENDPATH**/ ?>