<?php $__env->startSection('content'); ?>
<div class="card mb-4">
    <div class="card-header">
        <i class="fas fa-table mr-1"></i>
        Invoices List
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                <thead>
                    <tr>
                        <th>Invoice No.</th>
                        <th>Customer Name</th>
                        <th>Customer Email</th>
                        <th>Company</th>
                        <th>Address</th>
                        <!-- <th>Total_Price</th> -->
                        <th>Product Name</th>
                        <!-- <th>Sales Stock Price</th> -->
                        <th>Quantity</th>
                        <th>Total Cost</th>
                        <th>Due</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                	<?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($row->id); ?></td>
                        <td><?php echo e($row->customer_name); ?></td>
                        <td><?php echo e($row->customer_mail); ?></td>
                        <td><?php echo e($row->company); ?></td>
                        <td><?php echo e($row->address); ?></td>
                        <td><?php echo e($row->product_name); ?></td>
                        <td><?php echo e($row->quantity); ?></td>
                        <td><?php echo e($row->total); ?></td>
                        <td><?php echo e($row->due); ?></td>
                        <td><?php echo e($row->created_at); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<link href="https://cdn.datatables.net/1.10.20/css/dataTables.bootstrap4.min.css" rel="stylesheet" crossorigin="anonymous" />
        
<script>
   


   $('#dataTable').DataTable({
    columnDefs: [
    {bSortable: false, targets: [6]} 
  ],
                dom: 'lBfrtip',
           buttons: [
               {
                   extend: 'copyHtml5',
                   exportOptions: {
                    modifier: {
                        page: 'current'
                    },
                       columns: [ 0, ':visible' ]
                       
                   }
               },
               {
                   extend: 'excelHtml5',
                   exportOptions: {
                    modifier: {
                        page: 'current'
                    },
                    columns: [ 0, ':visible' ]
                   }
               },
               {
                   extend: 'pdfHtml5',
                   exportOptions: {
                    modifier: {
                        page: 'current'
                    },
                       columns: [ 0, 1, 2, 5 ]
                   }
               },
               'colvis'
           ]
           });
       </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin_master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/vikramkumar/Documents/Projects/Piyush/Kohinoor/resources/views/Admin/all_invoices.blade.php ENDPATH**/ ?>