@extends('layouts.main_layout')
@section('page-title', 'Hydro X | HOME')
@section('meta-desp', 'Hydro X is a well known Manufacturer, Stockist, Supplier and Exporter of Raw materials like Long Radius Bends, Compression Tube Fittings, Pipe Fittings, Forged Fittings, Flanges, Shims & Plates, Fasteners, Pipes &Tubes, Round Bars & Wire Etc')
@section('meta-keywords', 'Hydro X, metal, metals, mumbai, Water Treatment')

@section('internal-css')
    <style>
        .box-shadow-sm {
            box-shadow: 0.1rem 0.05rem 0.05rem 0.05rem rgba(0,0,0,0.1);
        }
        .clients-style img:hover {
            -webkit-transform: scale(1.04);
            -moz-transform: scale(1.04);
            transform: scale(1.04);
        }
        .bg-primary-solid, .primary-overlay-solid[data-overlay-dark]:before {
            background: #292dc2;
        }
    </style>
    <link rel="stylesheet" type="text/css" href="{{ asset('/img/slider/engine1/style.css') }}" />
    <script type="text/javascript" src="{{ asset('/img/slider/engine1/jquery.js') }}"></script>

    
@endsection

@section('content')
    <!-- start Carousel section-->
    <section class="pt-0 pb-2">
        <div class="conatainer-fluid">
            <div class="owl-carousel owl-theme text-center">
                <div class="item"><img src="{{ asset('/img/slider/images/slide1.jpg') }}" alt="..."></div>
                <div class="item"><img src="{{ asset('/img/slider/images/slide2.jpg') }}" alt="..."></div>
                <div class="item"><img src="{{ asset('/img/slider/images/slide3.jpg') }}" alt="..."></div>
                <div class="item"><img src="{{ asset('/img/slider/images/slide4.jpg') }}" alt="..."></div>
                <div class="item"><img src="{{ asset('/img/slider/images/slide5.jpg') }}" alt="..."></div>
            </div>
        </div>
    </section>
    <!-- end Carousel section--> 

    <section class="pt-3 pb-3">
        <div class="container">
            <div class="row">
                <div class="col text-center mt-3">
                    <h2 class="h3 line-height-normal mb-2">Welcome to <span style="color: #f8821e; font-weight: 650">Hydro </span> <span style="color: #00aeef; font-weight: 650">X</span></h2>
                    <h6>Hydro X is a trusted by industries and institutions across India.</h6>
                </div>
            </div>
        </div>
    </section>

    <section class="pt-4 pb-5">
        <div class="container">
            <div class="row">
                <div class="col-md-6 mb-1-9 mb-md-2-2">
                    <div class="media media-style1 pb-4">
                        <i class="fa fa-address-card mr-2-0 display-20"></i>
                        <div class="media-body">
                            <h3 class="h5">About Us</h3>
                            <p class="mb-0">
                                ydro X Water Treatment specializes in manufacturing advanced Industrial RO, Sewage (STP), and Effluent Treatment (ETP) systems for global markets.
                            </p>
                            <p class="mt-3 mb-0"><a href="{{ url('/about') }}" class="butn">Read More</a></p>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 mb-1-9 mb-md-2-2">
                    <div class="media media-style1 pb-4">
                        <i class="ti-pulse mr-2-0 display-20"></i>
                        <div class="media-body">
                            <h3 class="h5">Mission & Vision</h3>
                            <p class="mb-0">
                                We engineer sustainable, energy-efficient water solutions that strictly adhere to international environmental standards, ensuring a cleaner and greener future.
                            </p>
                            <p class="mt-3 mb-0"><a href="{{ url('/quality-policy') }}" class="butn">Read More</a></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- start features section -->
    <section class="pt-1">
        <div class="container">
            <div class="row">
                    <div class="col-md-6 col-lg-4 mb-2-2 mb-lg-0">
                    <div class="card card-style02 green">
                        <div class="card-body">
                            <span class=""><img class="mb-4 icon-circle rounded-circle object-fit-cover" src="img/images/watertreatment.jpg" alt=""></span>
                            <h3 class="h5">Water Treatment Plant</h3>
                            <p>At Hydro X Water Treatment Pvt Ltd, we engineer innovative solutions that turn water into a safe and sustainable resource.</p>
                            <a href="#!">Read more<i class="ti-arrow-right align-middle ml-2"></i></a>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 col-lg-4 mb-2-2 mb-lg-0">
                    <div class="card card-style02">
                        <div class="card-body">
                            <span class=""><img class="mb-4 icon-circle rounded-circle object-fit-cover" src="img/images/Sewage.jpg" alt=""></span>
                            <h3 class="h5">Sewage Treatment Plant</h3>
                            <p>We specialize in advanced and reliable solutions for the treatment of sewage water, protecting ecosystems.</p>
                            <a href="#!">Read more<i class="ti-arrow-right align-middle ml-2"></i></a>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 col-lg-4">
                    <div class="card card-style02 orange">
                        <div class="card-body">
                            <span class=""><img class="mb-4 icon-circle rounded-circle object-fit-cover" src="img/images/effluent.jpg" alt=""></span>
                            <h3 class="h5">Effluent Treatment Plant</h3>
                            <p>We offer a range of high-quality effluent treatment plants designed for efficient wastewater handling and disposal.</p>
                            <a href="#!">Read more<i class="ti-arrow-right align-middle ml-2"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- end features section -->

    <!-- FEATURES
    ================================================== -->
    <section class="parallax primary-overlay-solid" data-overlay-dark="85" data-background="img/bg/bg-01.jpg">
        <div class="container">

            <div class="w-md-75 w-lg-50 text-center mx-md-auto mb-6">
                <h2 class="line-title white">Why Choose Hydro X?</h2>
            </div>

            <div class="row mt-n2-9">
                <div class="col-md-6 col-lg-4 mt-2-9">
                    <div class="d-flex">
                        <div class="flex-shrink-0">
                            <i class="ti-pencil-alt text-white display-20"></i>
                        </div>
                        <div class="flex-grow-1 ml-4">
                            <h3 class="h5 text-white font-weight-500 mb-3">Premium Quality Standards</h3>
                            <p class="mb-0 text-white-90 font-weight-300">Our systems are engineered with unmatched precision to meet international benchmarks.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4 mt-2-9">
                    <div class="d-flex">
                        <div class="flex-shrink-0">
                            <i class="ti-ruler-alt-2 text-white display-20"></i>
                        </div>
                        <div class="flex-grow-1 ml-4">
                            <h3 class="h5 text-white font-weight-500 mb-3">Domain Expertise</h3>
                            <p class="mb-0 text-white-90 font-weight-300">Decades of hands-on experience in complex water treatment technologies and compliance.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4 mt-2-9">
                    <div class="d-flex">
                        <div class="flex-shrink-0">
                            <i class="ti-layers text-white display-20"></i>
                        </div>
                        <div class="flex-grow-1 ml-4">
                            <h3 class="h5 text-white font-weight-500 mb-3">Simplified Visual Communication</h3>
                            <p class="mb-0 text-white-90 font-weight-300">Well-documented with illustrations for clarity, even in technical workflows.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4 mt-2-9">
                    <div class="d-flex">
                        <div class="flex-shrink-0">
                            <i class="ti-bar-chart text-white display-20"></i>
                        </div>
                        <div class="flex-grow-1 ml-4">
                            <h3 class="h5 text-white font-weight-500 mb-3">Extensive Product Range</h3>
                            <p class="mb-0 text-white-90 font-weight-300">From RO to STP – find every solution under one roof, with end-to-end integration.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4 mt-2-9">
                    <div class="d-flex">
                        <div class="flex-shrink-0">
                            <i class="ti-files text-white display-20"></i>
                        </div>
                        <div class="flex-grow-1 ml-4">
                            <h3 class="h5 text-white font-weight-500 mb-3">Robust Warranty & Service</h3>
                            <p class="mb-0 text-white-90 font-weight-300">All installations come with extensive coverage and prompt support for peace of mind.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4 mt-2-9">
                    <div class="d-flex">
                        <div class="flex-shrink-0">
                            <i class="ti-server text-white display-20"></i>
                        </div>
                        <div class="flex-grow-1 ml-4">
                            <h3 class="h5 text-white font-weight-500 mb-3">On-Time Project Delivery</h3>
                            <p class="mb-0 text-white-90 font-weight-300">We adhere to strict timelines without compromising on quality and safety.</p>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>

    <!-- INNOVATE BUSINESS
    ================================================== -->
    <section class="md bg-light-grey">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-7 col-md-12 order-2 order-lg-1">
                    <div class="pe-0 pe-lg-5">
                        <h2 class="mx-md-auto ms-0 text-center text-lg-start h3 mb-4">Frequently Asked Questions</h2>
                        <div id="accordion" class="accordion-style01">
                            <div class="card">
                                <div class="card-header" id="headingOne">
                                    <div class="mb-0">
                                        <h5 class="btn btn-link" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                            <span class="counts">1</span>
                                            <span class="item-title">What distinguishes a mineral water plant from regular water treatment?</span>
                                        </h5>
                                    </div>
                                </div>
                                <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-bs-parent="#accordion">
                                    <div class="card-body">
                                        A mineral water plant not only purifies water but also enhances it with essential minerals, providing a healthier and more refreshing drinking experience.
                                    </div>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-header" id="headingTwo">
                                    <div class="mb-0">
                                        <h5 class="btn btn-link collapsed" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                            <span class="counts">2</span>
                                            <span class="item-title">Why is water softening necessary for households?</span>
                                        </h5>
                                    </div>
                                </div>
                                <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-bs-parent="#accordion">
                                    <div class="card-body">
                                        It removes excess calcium and magnesium, preventing scale buildup and improving cleaning efficiency of soaps and detergents.
                                    </div>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-header" id="headingThree">
                                    <div class="mb-0">
                                        <h5 class="btn btn-link collapsed" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                            <span class="counts">3</span>
                                            <span class="item-title">How does a water treatment plant work?</span>
                                        </h5>
                                    </div>
                                </div>
                                <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-bs-parent="#accordion">
                                    <div class="card-body">
                                        It uses filtration, sedimentation, and disinfection to remove impurities and ensure water meets safety standards.
                                    </div>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-header" id="headingFour">
                                    <div class="mb-0">
                                        <h5 class="btn btn-link collapsed" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                            <span class="counts">4</span>
                                            <span class="item-title">What is the purpose of a Kangen machine?</span>
                                        </h5>
                                    </div>
                                </div>
                                <div id="collapseFour" class="collapse" aria-labelledby="headingFour" data-bs-parent="#accordion">
                                    <div class="card-body">
                                        It uses filtration, sedimentation, and disinfection to remove impurities and ensure water meets safety standards.
                                    </div>
                                </div>
                            </div>
                             <div class="card">
                                <div class="card-header" id="heading5">
                                    <div class="mb-0">
                                        <h5 class="btn btn-link collapsed" data-bs-toggle="collapse" data-bs-target="#collapse5" aria-expanded="false" aria-controls="collapse5">
                                            <span class="counts">5</span>
                                            <span class="item-title">How does an effluent treatment plant contribute to environmental sustainability?</span>
                                        </h5>
                                    </div>
                                </div>
                                <div id="collapse5" class="collapse" aria-labelledby="collapse5" data-bs-parent="#accordion">
                                    <div class="card-body">
                                        It treats industrial wastewater before discharge, protecting ecosystems and enabling reuse of water.
                                    </div>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-header" id="heading6">
                                    <div class="mb-0">
                                        <h5 class="btn btn-link collapsed" data-bs-toggle="collapse" data-bs-target="#collapse6" aria-expanded="false" aria-controls="collapse6">
                                            <span class="counts">6</span>
                                            <span class="item-title">What features should be considered when choosing a water filling machine for a bottling plant?</span>
                                        </h5>
                                    </div>
                                </div>
                                <div id="collapse6" class="collapse" aria-labelledby="heading6" data-bs-parent="#accordion">
                                    <div class="card-body">
                                        Capacity, speed, hygiene, bottle compatibility, automatic capping, and labeling should be considered for efficient bottling.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-5 col-md-12 order-1 order-lg-2 mb-5 mb-lg-0 text-center text-lg-end">
                    <img src="img/content/content-01.png" class="img-effect" alt="...">
                </div>
            </div>
        </div>
    </section>

    <!-- CONTACT
    ================================================== -->
    <section class="md parallax cover-background theme-overlay" data-overlay-dark="9" data-background="img/banner/bg1.jpg">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-9 text-center">
                    <h2 class="text-white mb-4">Haven't found what you like? feel free to contact</h2>
                    <p class="text-white mb-4">We always try to provide you our best service.</p>
                    <a href="#!" class="butn white"><span>Contact Us</span></a>
                </div>

            </div>
        </div>

    </section>


    <!-- start clients section -->
    <section class="md pt-0 mt-6">
        <div class="section-clients pb-4">
            <div class="container-fluid wow fadeInUp" data-wow-delay=".2s">
                <div class="a-logo-marquee">
                    <div class="a-logo-marquee-track">
                        @for ($i = 0; $i < 2; $i++)
                        <div class="a-logo-item"><img src="{{ asset('/img/clients/client1.jpg') }}" alt="Partner 1"></div>
                        <div class="a-logo-item"><img src="{{ asset('/img/clients/client2.jpg') }}" alt="Partner 2"></div>
                        <div class="a-logo-item"><img src="{{ asset('/img/clients/client3.jpg') }}" alt="Partner 3"></div>
                        <div class="a-logo-item"><img src="{{ asset('/img/clients/client4.jpg') }}" alt="Partner 4"></div>
                        <div class="a-logo-item"><img src="{{ asset('/img/clients/client5.jpg') }}" alt="Partner 5"></div>
                        <div class="a-logo-item"><img src="{{ asset('/img/clients/client6.jpg') }}" alt="Partner 6"></div>
                        @endfor
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- end clients section -->

    <!-- CONTACT
    ================================================== -->
    <section class="p-0">
        <div class="container lg-container">
            <div class="parallax text-center cover-background p-2-0 p-sm-2-8 p-lg-7 p-xl-10 wow fadeInUp theme-overlay-90 rounded z-index-9" data-wow-delay=".2s" data-overlay-dark="9" data-background="img/bg/footer-bg.jpg">

                <div class="position-relative z-index-1">
                    <h5 class="mb-4 text-white">Drop a message on WhatsApp</h5>
                    <p class="w-95 w-md-80 w-lg-65 w-xl-50 mx-auto text-white mb-4">and get a reply in a flash</p>
                    <a href="#!" class="butn style-two"><span><i class="fab fa-whatsapp"></i>&nbsp;&nbsp;Whatsapp</span></a>
                </div>

            </div>
        </div>
    </section>
@endsection