@extends('layouts.main_layout')
@section('page-title', 'Enquiry Now | Hydro X')
@section('meta-desp', 'Enquiry about our products')
@section('meta-keywords', 'enquiry, contact Hydro X, Hydro X, about Hydro X, contact-us')

@section('internal-css')
    <style>
    	.my-list li {
    		margin-bottom: 15px !important;
    	}
    </style>
@endsection

@section('content')

	<!-- start page title section -->
    <section class="page-title-section bg-img cover-background" data-overlay-dark="65" data-background="{{ asset('/img/bg/page-title.jpg') }}">
        <div class="container">

            <div class="row">
                <div class="col-md-12">
                    <h1>Enquiry</h1>
                </div>
                <div class="col-md-12">
                    <ul>
                        <li><a href="/">Home</a></li>
                        <li><a href="javascript:void(0)">Enquiry</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </section>
    <!-- end page title section -->

    @if(Session::has('success_title'))
        <div class="container">
            <div class="row mt-4">
                <div class="col">
                    <div class="alert alert-success">
                        <b>{{ Session::get('success_title') }}</b>
                        <p>{{ Session::get('success_msg') }}</p>
                    </div>
                </div>
            </div>
        </div>
    @endif
	
	<!-- start apply job section -->
    <section>
        <div class="container">
            <div class="row">

                <!--  start left panel-->
                <div class="col-lg-8 col-md-12 mb-5 mb-lg-0">
                    <div class="pr-lg-5">

                        <h2 class="mb-4">Send Us Message!</h2>

                        <form action="{{ route('enquiry') }}" method="post" enctype="multipart/form-data">
                            {{csrf_field()}}
                            <div class="quform-elements">
                                <div class="row">
                                    <!-- Begin Text input element -->
                                    <div class="col-12">
                                        <div class="quform-element form-group">
                                            <label for="company_name">Business / Organization Name <span class="quform-required">*</span></label>
                                            <div class="quform-input">
                                                <input class="form-control @error('company_name') is-invalid @enderror" id="company_name" type="text" name="company_name" placeholder="Company Name"  required="" />
                                                @error('company_name')
                                                   <span class="invalid-feedback" role="alert">
                                                       <strong>{{ $message }}</strong>
                                                   </span>
                                                @enderror
                                            </div>
                                        </div>

                                    </div>
                                    <!-- End Text input element -->

                                    <!-- Begin Text input element -->
                                    <div class="col-12">
                                        <div class="quform-element form-group">
                                            <label for="name">Name <span class="quform-required">*</span></label>
                                            <div class="quform-input">
                                                <input class="form-control @error('name') is-invalid @enderror" id="name" type="text" name="name" placeholder="Name" required="" />
                                                @error('name')
                                                   <span class="invalid-feedback" role="alert">
                                                       <strong>{{ $message }}</strong>
                                                   </span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <!-- End Text input element -->

                                    <!-- Begin Text input element -->
                                    <div class="col-12">
                                        <div class="quform-element form-group">
                                            <label for="email">Email Address <span class="quform-required">*</span></label>
                                            <div class="quform-input">
                                                <input class="form-control @error('email') is-invalid @enderror" id="email" type="text" name="email" placeholder="name@example.com" required="" />
                                                @error('email')
                                                   <span class="invalid-feedback" role="alert">
                                                       <strong>{{ $message }}</strong>
                                                   </span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <!-- End Text input element -->

                                    <!-- Begin Text input element -->
                                    <div class="col-12">
                                        <div class="quform-element form-group">
                                            <label for="tel">Phone Number <span class="quform-required">*</span></label></label>
                                            <div class="quform-input">
                                                <input class="form-control @error('phone_number') is-invalid @enderror" id="linkedin" type="tel" name="phone_number" placeholder="Phone Number" required="" />
                                                @error('phone_number')
                                                   <span class="invalid-feedback" role="alert">
                                                       <strong>{{ $message }}</strong>
                                                   </span>
                                                @enderror
                                            </div>
                                        </div>

                                    </div>
                                    <!-- End Text input element -->

                                    <!-- Begin Textarea element -->
                                    <div class="col-md-12">
                                        <div class="quform-element form-group">
                                            <label for="message">Requirement <span class="quform-required">*</span></label>
                                            <div class="quform-input">
                                                <textarea class="form-control @error('requirements') is-invalid @enderror" id="message" name="requirements" rows="4" placeholder="Requirement"></textarea>
                                                @error('requirements')
                                                   <span class="invalid-feedback" role="alert">
                                                       <strong>{{ $message }}</strong>
                                                   </span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <!-- End Textarea element -->

                                    <!-- Begin Submit button -->
                                    <div class="col-md-12">
                                        <div class="quform-submit-inner">
                                            <button class="butn style-one fill" type="submit"><span>Submit</span></button>
                                        </div>
                                    </div>
                                    <!-- End Submit button -->

                                </div>

                            </div>
                        </form>

                    </div>

                </div>
                <!--  end left panel-->

                <!--  start right panel -->
                <div class="col-lg-4 col-md-12">

                    <div class="widget-block">
                        <h4 class="mb-3">Products</h4>
                        <ul class="list-style5 my-list" style="list-style: none;">
                            <li>
                                <a href="#!" class="btn btn-outline-primary btn-block">Mineral Water Plant</a>
                            </li>
                            <li>
                                <a href="#!" class="btn btn-outline-primary btn-block">Water Filling Machine</a>
                            </li>
                            <li>
                                <a href="#!" class="btn btn-outline-primary btn-block">1 Litre Bottling Plant</a>
                            </li>
                            <li>
                                <a href="#!" class="btn btn-outline-primary btn-block">Industrial RO Water Plant</a>
                            </li>
                            <li>
                                <a href="#!" class="btn btn-outline-primary btn-block">Water Softening Plant</a>
                            </li>
                            <li>
                                <a href="#!" class="btn btn-outline-primary btn-block">Sewage Treatment Plant</a>
                            </li>
                             <li>
                                <a href="#!" class="btn btn-outline-primary btn-block">Effluent Treatment Plant</a>
                            </li>
                        </ul>

                    </div>

                </div>
                <!--  end right panel -->

            </div>
        </div>
    </section>
    <!-- end apply job section -->

    <!-- start contact section -->
    <section class="p-0">
        <div class="container lg-container">
            <div class="parallax text-center cover-background p-2-0 p-sm-2-8 p-lg-8 p-xl-10 wow fadeInUp theme-overlay-180 rounded z-index-9" data-wow-delay=".2s" data-overlay-dark="9" data-background="img/bg/footer-bg.jpg">

                <div class="position-relative z-index-1">
                    <h4 class="mb-4 text-white">We’re Just a Message Away</h4>
                    <p class="w-95 w-md-80 w-lg-65 w-xl-50 mx-auto text-white mb-4">We’re here to help you with safe, efficient, and eco-friendly treatment</p>
                    <a href="https://api.whatsapp.com/send?phone=919838600270&text=Hello" class="butn style-two">
                        <span><i class="fab fa-whatsapp"></i>&nbsp;&nbsp;Let's Chat</span>
                    </a>
                </div>

            </div>
        </div>
    </section>
    <!-- end contact section -->

@endsection
