@extends('layouts.main_layout')
@section('page-title', 'About Us')
@section('meta-desp', 'ABOUT US - Hydro X')
@section('meta-keywords', 'Hydro X, about Hydro X, about-us, Water Treatment')

@section('internal-css')
    
@endsection

@section('content')
    <!-- start page title section -->
    <section class="page-title-section bg-img cover-background" data-overlay-dark="65" data-background="{{ asset('/img/bg/page-title.jpg') }}">
        <div class="container">

            <div class="row">
                <div class="col-md-12">
                    <h1>About Us</h1>
                </div>
                <div class="col-md-12">
                    <ul>
                        <li><a href="/">Home</a></li>
                        <li><a href="javascript:void(0)">About Us</a></li>
                    </ul>
                </div>
            </div>

        </div>
    </section>
    <!-- end page title section -->

    <!-- ABOUT
        ================================================== -->
    <section>
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 mb-5 mb-lg-0 hover-style3 text-center text-lg-start">
                    <div class="px-3 px-md-5 px-lg-0">
                        <img src="{{ asset('/img/content/content-10.svg') }}" alt="">
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="ps-lg-5">

                        <h2 class="mb-3">Top 5 Best Effluent Treatment Plant Manufacturers in Delhi, India</h2>
                        <p class="display-29 mb-1-2"><b><span style="color: #f8821e">HYDRO X </span> <span style="color: #00aeef">WATER TREATMENT</span></b> a pioneering force in the water treatment industry committed to delivering innovative solutions since our establishment in 2016. Founded by visionary CEO <b>Mr. Rahul Tiwari</b>, we have evolved into a trusted name synonymous with excellence and sustainability in water management.</p>

                        <p class="mb-1-3">As a privately held company, we operate under the legal status of a Private Limited entity, ensuring a focus on quality, integrity, and customer satisfaction.</p>

                        <b>We provide</b>
                        <ul class="list-style6 ps-0 mb-2-2">
                            <li>Water Treatment Plants</li>
                            <li>High-quality Mineral Water Plants</li>
                            <li>Revolutionary Enagic Kangen Machines</li>
                        </ul>

                        <a href="#!" class="butn style-one fill">ENQUIRE NOW</a>

                    </div>
                </div>
            </div>
        </div>
    </section>
    

    <!-- Company Factsheet
        ================================================== -->
    <section class="bg-grey">
        <div class="container">
            <div class="w-md-85 w-lg-65 w-xl-50 text-center mx-auto mb-6 mb-lg-8">
                <h2 class="mb-0">Company Factsheet</h2>
                <p>Hydro X Water Treatment excels in advanced water purification, providing sustainable, efficient solutions for pristine water quality.</p>
            </div>
            <div class="row mt-n4">
                <div class="col-md-6 col-lg-3 mt-4">
                    <div class="card card-style05 pt-2-8 pb-2-4 px-1-6 wow fadeInUp" data-wow-delay=".2s">
                        <i class="fas fa-globe"></i>
                        <h6 class="h6 mb-3">Nature of Business</h6>
                        <p class="mb-0 w-90 w-md-75 w-lg-100 mx-auto">Manufacturer, Supplier & Exporter</p>

                    </div>
                </div>
                <div class="col-md-6 col-lg-3 mt-4">
                    <div class="card card-style05 pt-2-8 pb-2-4 px-1-6 wow fadeInUp" data-wow-delay=".4s">
                        <i class="fas fa-building"></i>
                        <h6 class="h6 mb-3">Year of Establishment</h6>
                        <p class="mb-0 w-90 w-md-75 w-lg-100 mx-auto">2016</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3 mt-4">
                    <div class="card card-style05 pt-2-8 pb-2-4 px-1-6 wow fadeInUp" data-wow-delay=".6s">
                        <i class="fas fa-balance-scale"></i>
                        <h6 class="h6 mb-3">Legal Status of Firm</h6>
                        <p class="mb-0 w-90 w-md-75 w-lg-100 mx-auto">Private Limited</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3 mt-4">
                    <div class="card card-style05 pt-2-8 pb-2-4 px-1-6 wow fadeInUp" data-wow-delay=".8s">
                        <i class="fas fa-file-invoice"></i>
                        <h6 class="h6 mb-3">GST Number</h6>
                        <p class="mb-0 w-90 w-md-75 w-lg-100 mx-auto">09AAECH0061M1ZJ</p>

                    </div>
                </div>
            </div>
        </div>
    </section>

     <!-- start faq section -->
    <section class="bg-light">
        <div class="container">
            <div class="w-md-85 w-lg-65 w-xl-50 text-center mx-auto mb-6 mb-lg-8">
                <h2 class="mb-0">Frequently Asked Questions</h2>
            </div>
            <div class="row">
                <div class="col-lg-5 mb-3 mb-lg-0">
                    <img src="{{ asset('/img/content/faq-content.png') }}" alt="...">
                </div>
                <div class="col-lg-7 col-xl-6 offset-xl-1">

                    <div id="accordion" class="accordion-style01">
                        <div class="card">
                            <div class="card-header" id="headingOne">
                                <div class="mb-0">
                                    <h5 class="btn btn-link" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                        <span class="counts">1</span>
                                        <span class="item-title">What distinguishes a mineral water plant from regular water treatment??</span>
                                    </h5>
                                </div>
                            </div>
                            <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-bs-parent="#accordion">
                                <div class="card-body">
                                    A mineral water plant not only purifies water but also enhances it with essential minerals, providing a healthier and more refreshing drinking experience.
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header" id="headingTwo">
                                <div class="mb-0">
                                    <h5 class="btn btn-link collapsed" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                        <span class="counts">2</span>
                                        <span class="item-title">Why is water softening necessary for households?</span>
                                    </h5>
                                </div>
                            </div>
                            <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-bs-parent="#accordion">
                                <div class="card-body">
                                    It removes excess calcium and magnesium, preventing scale buildup and improving cleaning efficiency of soaps and detergents.
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header" id="headingThree">
                                <div class="mb-0">
                                    <h5 class="btn btn-link collapsed" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                        <span class="counts">3</span>
                                        <span class="item-title">How does a water treatment plant work?</span>
                                    </h5>
                                </div>
                            </div>
                            <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-bs-parent="#accordion">
                                <div class="card-body">
                                    It uses filtration, sedimentation, and disinfection to remove impurities and ensure water meets safety standards.
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header" id="headingFour">
                                <div class="mb-0">
                                    <h5 class="btn btn-link collapsed" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                        <span class="counts">4</span>
                                        <span class="item-title">What is the purpose of a Kangen machine?</span>
                                    </h5>
                                </div>
                            </div>
                            <div id="collapseFour" class="collapse" aria-labelledby="headingFour" data-bs-parent="#accordion">
                                <div class="card-body">
                                    It uses filtration, sedimentation, and disinfection to remove impurities and ensure water meets safety standards.
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header" id="headingFive">
                                <div class="mb-0">
                                    <h5 class="btn btn-link collapsed" data-bs-toggle="collapse" data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                                        <span class="counts">5</span>
                                        <span class="item-title">How does an effluent treatment plant contribute to environmental sustainability?</span>
                                    </h5>
                                </div>
                            </div>
                            <div id="collapseFive" class="collapse" aria-labelledby="headingFive" data-bs-parent="#accordion">
                                <div class="card-body">
                                    It treats industrial wastewater before discharge, protecting ecosystems and enabling reuse of water.
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header" id="headingSix">
                                <div class="mb-0">
                                    <h5 class="btn btn-link collapsed" data-bs-toggle="collapse" data-bs-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                                        <span class="counts">6</span>
                                        <span class="item-title">What features should be considered when choosing a water filling machine for a bottling plant?</span>
                                    </h5>
                                </div>
                            </div>
                            <div id="collapseSix" class="collapse" aria-labelledby="headingSix" data-bs-parent="#accordion">
                                <div class="card-body">
                                    Capacity, speed, hygiene, bottle compatibility, automatic capping, and labeling should be considered for efficient bottling.
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>

    <!-- start clients section -->
    <section class="md pt-8 mb-8">
        <div class="section-clients pb-4">
            <div class="container wow fadeInUp" data-wow-delay=".2s">
                <div class="a-logo-marquee">
                    <div class="a-logo-marquee-track">
                        @for ($i = 0; $i < 2; $i++)
                        <div class="a-logo-item"><img src="{{ asset('/img/clients/client1.jpg') }}" alt="Partner 1"></div>
                        <div class="a-logo-item"><img src="{{ asset('/img/clients/client2.jpg') }}" alt="Partner 2"></div>
                        <div class="a-logo-item"><img src="{{ asset('/img/clients/client3.jpg') }}" alt="Partner 3"></div>
                        <div class="a-logo-item"><img src="{{ asset('/img/clients/client4.jpg') }}" alt="Partner 4"></div>
                        <div class="a-logo-item"><img src="{{ asset('/img/clients/client5.jpg') }}" alt="Partner 5"></div>
                        <div class="a-logo-item"><img src="{{ asset('/img/clients/client6.jpg') }}" alt="Partner 6"></div>
                        @endfor
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- end clients section -->

@endsection